package bin.mt.plugin.pusher;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;

import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Objects;

public class PusherActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String mtPackageName;
        try (InputStream is = PusherActivity.class.getResourceAsStream("/MTPluginConfig.json")) {
            Objects.requireNonNull(is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len;
            while ((len = is.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            JSONObject json = new JSONObject(baos.toString("UTF-8"));
            mtPackageName = json.getString("pushTarget");
            if ("auto".equals(mtPackageName)) {
                mtPackageName = null;
            }
        } catch (Exception e) {
            Toast.makeText(this, "文件解析失败: MTPluginConfig.json", Toast.LENGTH_LONG).show();
            return;
        }

        Intent intent = new Intent();
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra("apkPath", getApplicationInfo().sourceDir);
        intent.setClassName(mtPackageName != null ? mtPackageName : "bin.mt.plus", "bin.mt.plugin.PusherReceiver");
        try {
            startActivity(intent);
            finish();
            return;
        } catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
        if (mtPackageName == null) {
            intent.setClassName("bin.mt.plus.canary", "bin.mt.plugin.PusherReceiver");
            try {
                startActivity(intent);
                finish();
                return;
            } catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (mtPackageName != null) {
            Toast.makeText(this, "请安装最新版MT管理器：" + mtPackageName, Toast.LENGTH_LONG).show();
        } else {
            Toast.makeText(this, "请安装最新版MT管理器！", Toast.LENGTH_LONG).show();
        }
        Uri uri = Uri.parse("https://mt2.cn");
        intent = new Intent(Intent.ACTION_VIEW, uri);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
        finish();
    }

}
