package bin.mt.plugin.push;

import android.Manifest;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.provider.Settings;
import android.widget.Toast;

import java.io.InputStream;
import java.util.Properties;

public class PusherActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String mtPackageName = null;

        try (InputStream is = PusherActivity.class.getResourceAsStream("/pusher.conf")) {
            if (is != null) {
                Properties properties = new Properties();
                properties.load(is);
                mtPackageName = properties.getProperty("mtPackageName", null);
                if ("auto".equals(mtPackageName)) {
                    mtPackageName = null;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        Intent intent = new Intent();
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra("apkPath", getApplicationInfo().sourceDir);
        if (mtPackageName != null) {
            intent.setClassName(mtPackageName, "bin.mt.plugin.PusherReceiver");
        } else {
            intent.setClassName("bin.mt.plus", "bin.mt.plugin.PusherReceiver");
        }
        try {
            startActivity(intent);
            finish();
            return;
        } catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
        if (mtPackageName == null) {
            intent.setClassName("bin.mt.plus.canary", "bin.mt.plugin.PusherReceiver");
            try {
                startActivity(intent);
                finish();
                return;
            } catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (mtPackageName != null) {
            Toast.makeText(this, "请安装最新版MT管理器：" + mtPackageName, Toast.LENGTH_LONG).show();
        } else {
            Toast.makeText(this, "请安装最新版MT管理器！", Toast.LENGTH_LONG).show();
        }
        Uri uri = Uri.parse("https://mt2.cn");
        intent = new Intent(Intent.ACTION_VIEW, uri);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
        finish();
    }

}
