/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class MtlValidator {
    public static void validate(File file) throws MtlValidationException, IOException {
        List lines;
        try (FileInputStream is = new FileInputStream(file);){
            lines = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        MtlValidator.parse(lines, file.getPath());
    }

    public static List<String> validateAll(List<File> files) {
        ArrayList<String> errors = new ArrayList<String>();
        for (File file : files) {
            try {
                MtlValidator.validate(file);
            }
            catch (MtlValidationException e) {
                errors.add(e.getMessage());
            }
            catch (IOException e) {
                errors.add("Failed to read file: " + file.getPath() + " - " + e.getMessage());
            }
        }
        return errors;
    }

    private static void parse(List<String> lines, String filePath) throws MtlValidationException {
        HashMap<String, String> map = new HashMap<String, String>();
        int size = lines.size();
        for (int lineCount = 1; lineCount <= size; ++lineCount) {
            String line = lines.get(lineCount - 1);
            if (MtlValidator.isCommentOrEmptyLine(line)) continue;
            int i = line.indexOf(": ");
            if (i == -1) {
                throw new MtlValidationException("Parse local string failed: " + line + " (in " + filePath + "  line: " + lineCount + ")");
            }
            String key = line.substring(0, i);
            if (key.indexOf(32) != -1 || key.indexOf(9) != -1) {
                throw new MtlValidationException("Key cannot contain spaces: " + line + " (in " + filePath + "  line: " + lineCount + ")");
            }
            if (map.containsKey(key)) {
                throw new MtlValidationException("Duplicate key error: '" + key + "' (in " + filePath + "  line: " + lineCount + ")");
            }
            StringBuilder value = new StringBuilder();
            String originalValue = line.substring(i + 2);
            while (MtlValidator.parseValue(originalValue, value, filePath, lineCount) && ++lineCount <= size) {
                originalValue = lines.get(lineCount - 1);
            }
            map.put(key, value.toString());
        }
    }

    private static boolean isCommentOrEmptyLine(String line) {
        int len = line.length();
        block4: for (int i = 0; i < len; ++i) {
            switch (line.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block4;
                }
                case '#': {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean parseValue(String line, StringBuilder result, String filePath, int lineCount) throws MtlValidationException {
        if (line.isEmpty()) {
            return false;
        }
        int len = line.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                if (++i == len) {
                    return true;
                }
                c = line.charAt(i);
                switch (c) {
                    case 'n': {
                        result.append('\n');
                        continue block9;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block9;
                    }
                    case 't': {
                        result.append('\t');
                        continue block9;
                    }
                    case '\\': {
                        result.append('\\');
                        continue block9;
                    }
                    case 'U': 
                    case 'u': {
                        if (i + 4 >= len) {
                            throw new MtlValidationException("Invalid Unicode escape character: \\" + line.substring(i) + " (in " + filePath + "  line: " + lineCount + ")");
                        }
                        String unicodeStr = line.substring(i + 1, i + 5);
                        try {
                            int unicodeVal = Integer.parseInt(unicodeStr, 16);
                            result.append((char)unicodeVal);
                            i += 4;
                            continue block9;
                        }
                        catch (NumberFormatException e) {
                            throw new MtlValidationException("Invalid Unicode escape character: \\" + c + unicodeStr + " (in " + filePath + "  line: " + lineCount + ")");
                        }
                    }
                    default: {
                        throw new MtlValidationException("Invalid escape character: \\" + c + " (in " + filePath + "  line: " + lineCount + ")");
                    }
                }
            }
            result.append(c);
        }
        return false;
    }

    public static class MtlValidationException
    extends Exception {
        public MtlValidationException(String message) {
            super(message);
        }
    }
}

