/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class InterfaceValidator {
    private static final String TRANSLATION_ENGINE = "bin.mt.plugin.api.translation.TranslationEngine";
    private static final String TEXT_EDITOR_FUNCTION = "bin.mt.plugin.api.editor.TextEditorFunction";
    private static final String TEXT_EDITOR_FLOATING_MENU = "bin.mt.plugin.api.editor.TextEditorFloatingMenu";
    private static final String TEXT_EDITOR_TOOL_MENU = "bin.mt.plugin.api.editor.TextEditorToolMenu";
    private static final String PLUGIN_PREFERENCE = "bin.mt.plugin.api.preference.PluginPreference";
    private static final String[] VALID_INTERFACE_TYPES = new String[]{"bin.mt.plugin.api.translation.TranslationEngine", "bin.mt.plugin.api.editor.TextEditorFunction", "bin.mt.plugin.api.editor.TextEditorFloatingMenu", "bin.mt.plugin.api.editor.TextEditorToolMenu"};
    private final URLClassLoader classLoader;

    public InterfaceValidator(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<String> validate(String mainPreference, String[] interfaces) {
        ArrayList<String> errors = new ArrayList<String>();
        if (interfaces != null && interfaces.length > 0) {
            for (int i = 0; i < interfaces.length; ++i) {
                String interfaceName = interfaces[i];
                try {
                    this.validateInterface(interfaceName, i);
                    continue;
                }
                catch (InterfaceValidationException e) {
                    errors.add(e.getMessage());
                }
            }
        }
        if (mainPreference != null && !mainPreference.isEmpty()) {
            try {
                this.validateMainPreference(mainPreference);
            }
            catch (InterfaceValidationException e) {
                errors.add(e.getMessage());
            }
        }
        return errors;
    }

    private void validateInterface(String className, int index) throws InterfaceValidationException {
        Class<?> clazz = this.loadAndCheckClass(className, "mtPlugin.interfaces[" + index + "]");
        boolean validInterface = false;
        for (String interfaceType : VALID_INTERFACE_TYPES) {
            try {
                Class<?> interfaceClass = Class.forName(interfaceType, false, this.classLoader);
                if (!interfaceClass.isAssignableFrom(clazz)) continue;
                validInterface = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!validInterface) {
            throw new InterfaceValidationException("mtPlugin.interfaces[" + index + "] = \"" + className + "\"\n    Error: Class does not implement any valid interface type.\n    Must implement one of:\n      - TranslationEngine\n      - TextEditorFunction\n      - TextEditorFloatingMenu\n      - TextEditorToolMenu");
        }
    }

    private void validateMainPreference(String className) throws InterfaceValidationException {
        Class<?> clazz = this.loadAndCheckClass(className, "mtPlugin.mainPreference");
        try {
            Class<?> pluginPreferenceClass = Class.forName(PLUGIN_PREFERENCE, false, this.classLoader);
            if (!pluginPreferenceClass.isAssignableFrom(clazz)) {
                throw new InterfaceValidationException("mtPlugin.mainPreference = \"" + className + "\"\n    Error: Class must implement PluginPreference interface.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new InterfaceValidationException("mtPlugin.mainPreference = \"" + className + "\"\n    Error: PluginPreference interface not found in classpath.\n    Make sure plugin-api is in dependencies.");
        }
    }

    private Class<?> loadAndCheckClass(String className, String configField) throws InterfaceValidationException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new InterfaceValidationException(configField + " = \"" + className + "\"\n    Error: Class not found.");
        }
        int modifiers = clazz.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new InterfaceValidationException(configField + " = \"" + className + "\"\n    Error: Class must be public.");
        }
        if (Modifier.isAbstract(modifiers)) {
            throw new InterfaceValidationException(configField + " = \"" + className + "\"\n    Error: Class cannot be abstract.");
        }
        if (Modifier.isInterface(modifiers)) {
            throw new InterfaceValidationException(configField + " = \"" + className + "\"\n    Error: Must be a class, not an interface.");
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new InterfaceValidationException(configField + " = \"" + className + "\"\n    Error: Class must have a public no-arg constructor.");
            }
        }
        catch (NoSuchMethodException e) {
            throw new InterfaceValidationException(configField + " = \"" + className + "\"\n    Error: Class must have a public no-arg constructor.");
        }
        return clazz;
    }

    public static class InterfaceValidationException
    extends Exception {
        public InterfaceValidationException(String message) {
            super(message);
        }
    }
}

