/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

import java.util.Arrays;
import org.json.JSONObject;

public class MTPluginConfig {
    private String pushTarget = "auto";
    private String pluginID;
    private int versionCode = 1;
    private String versionName = "null";
    private String name;
    private String description;
    private String mainPreference;
    private String[] interfaces;

    public String getPushTarget() {
        return this.pushTarget;
    }

    public void setPushTarget(String pushTarget) {
        this.pushTarget = pushTarget;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public void setPluginID(String pluginID) {
        this.pluginID = pluginID;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(int versionCode) {
        this.versionCode = versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMainPreference() {
        return this.mainPreference;
    }

    public void setMainPreference(String mainPreference) {
        this.mainPreference = mainPreference;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public MTPluginConfig validate() {
        if (this.pluginID == null || this.pluginID.trim().isEmpty()) {
            throw new IllegalArgumentException("mtPlugin.pluginID is required and cannot be empty");
        }
        if (!this.pluginID.matches("^[a-zA-Z0-9_.]+$")) {
            throw new IllegalArgumentException("mtPlugin.pluginID can only contain letters, numbers, underscores and dots");
        }
        if (this.versionCode <= 0) {
            throw new IllegalArgumentException("mtPlugin.versionCode must be greater than 0");
        }
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("mtPlugin.name is required and cannot be empty");
        }
        if (this.description == null) {
            throw new IllegalArgumentException("mtPlugin.description is required");
        }
        return this;
    }

    public JSONObject getManifestJson(int minAndroidVersion) {
        JSONObject json = new JSONObject();
        json.put("minAndroidVersion", minAndroidVersion);
        json.put("pluginSdkVersion", 3);
        json.put("pluginID", (Object)this.pluginID);
        json.put("versionCode", this.versionCode);
        json.put("versionName", (Object)this.versionName);
        json.put("name", (Object)this.name);
        json.put("description", (Object)this.description);
        if (this.mainPreference != null && !this.mainPreference.isEmpty()) {
            json.put("mainPreference", (Object)this.mainPreference);
        }
        if (this.interfaces != null && this.interfaces.length > 0) {
            json.put("interfaces", (Object)this.interfaces);
        }
        json.put("dexMode", true);
        return json;
    }

    public JSONObject getConfigJson(int minAndroidVersion) {
        JSONObject json = new JSONObject();
        json.put("manifest", (Object)this.getManifestJson(minAndroidVersion));
        json.put("pushTarget", (Object)this.pushTarget);
        json.put("excludedFiles", Arrays.asList("META-INF/", "lib/", "MTPluginConfig.json", "AndroidManifest.xml", "resources.arsc", "kotlin-tooling-metadata.json"));
        return json;
    }
}

