/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

import bin.mt.plugin.MTPluginConfig;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.SourceDirectories;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.writer.io.DexDataStore;
import com.android.tools.smali.dexlib2.writer.io.MemoryDataStore;
import com.android.tools.smali.dexlib2.writer.pool.DexPool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.json.JSONObject;

public class MTPlugin
implements Plugin<Project> {
    static final int PLUGIN_SDK_VERSION = 3;
    static final String LIB_PLUGIN_PUSHER = "bin.mt.plugin:pusher:1.0.0-alpha2";
    static final String LIB_PLUGIN_API = "bin.mt.plugin:api:3.0.0-alpha5";

    public void apply(@Nonnull Project project) {
        if (!project.getPlugins().hasPlugin("com.android.application")) {
            throw new IllegalStateException("Packer plugin can only be applied to Android Application projects");
        }
        project.getDependencies().add("debugImplementation", (Object)LIB_PLUGIN_PUSHER);
        project.getDependencies().add("compileOnly", (Object)LIB_PLUGIN_API);
        project.getExtensions().create("mtPlugin", MTPluginConfig.class, new Object[0]);
        ApplicationAndroidComponentsExtension appExtension = (ApplicationAndroidComponentsExtension)project.getExtensions().getByType(ApplicationAndroidComponentsExtension.class);
        appExtension.onVariants(appExtension.selector().all(), variant -> {
            switch (variant.getName()) {
                case "debug": {
                    this.onDebugVariant(project, (ApplicationVariant)variant);
                    break;
                }
                case "release": {
                    this.onReleaseVariant(project, (ApplicationVariant)variant);
                }
            }
        });
    }

    private void onDebugVariant(Project project, ApplicationVariant variant) {
        TaskProvider generateDebugMTPluginConfigTask = project.getTasks().register("generateDebugMTPluginConfig", GenerateConfigFileTask.class, task -> {
            int minSdkVersion = variant.getMinSdk().getApiLevel();
            if (minSdkVersion < 24) {
                Integer level;
                Object deviceApiLevel = project.findProperty("android.injected.build.api");
                if (deviceApiLevel instanceof String) {
                    String str = (String)deviceApiLevel;
                    deviceApiLevel = Integer.parseInt(str);
                }
                if (deviceApiLevel instanceof Integer && (level = (Integer)deviceApiLevel) >= 24) {
                    minSdkVersion = 24;
                }
            }
            task.getMinAndroidVersion().set((Object)minSdkVersion);
            task.getTimestamp().set((Object)System.currentTimeMillis());
        });
        SourceDirectories.Flat resources = Objects.requireNonNull(variant.getSources().getResources());
        resources.addGeneratedSourceDirectory(generateDebugMTPluginConfigTask, GenerateConfigFileTask::getGeneratedResourcesDirectory);
    }

    private void onReleaseVariant(Project project, ApplicationVariant variant) {
        project.afterEvaluate(p -> project.getTasks().register("packageReleaseMtp", PackMTPFileTask.class, task -> {
            Task packageApkTask = (Task)project.getTasks().named("packageRelease").get();
            task.dependsOn(new Object[]{packageApkTask});
            task.setGroup("mt-plugin");
            task.setDescription("Generate MT Plugin installation package file");
            task.getMinAndroidVersion().set((Object)variant.getMinSdk().getApiLevel());
            task.getInputDirectory().set(packageApkTask.getOutputs().getFiles().filter(file -> file.getName().equals("output-metadata.json")).getSingleFile().getParentFile());
            task.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("outputs/mt-plugin"));
        }));
    }

    private static void writeDex(ZipArchiveOutputStream zos, DexPool dexPool, int dexIndex) throws IOException {
        MemoryDataStore dataStore = new MemoryDataStore();
        dexPool.writeTo((DexDataStore)dataStore);
        zos.putArchiveEntry(new ZipArchiveEntry(MTPlugin.getDexName(dexIndex)));
        zos.write(dataStore.getBuffer(), 0, dataStore.getSize());
    }

    private static List<ZipArchiveEntry> getDexEntries(ZipFile zipFile) throws IOException {
        String name;
        ZipArchiveEntry entry;
        int index = 0;
        if ((entry = zipFile.getEntry(name = MTPlugin.getDexName(++index))) == null) {
            throw new IOException("Entry not found: " + name);
        }
        ArrayList<ZipArchiveEntry> list = new ArrayList<ZipArchiveEntry>();
        while (entry != null) {
            list.add(entry);
            name = MTPlugin.getDexName(++index);
            entry = zipFile.getEntry(name);
        }
        return list;
    }

    private static String getDexName(int index) {
        if (index <= 0) {
            throw new IllegalArgumentException();
        }
        if (index == 1) {
            return "classes.dex";
        }
        return "classes" + index + ".dex";
    }

    public static abstract class GenerateConfigFileTask
    extends DefaultTask {
        @Input
        public abstract Property<Integer> getMinAndroidVersion();

        @Input
        public abstract Property<Long> getTimestamp();

        @OutputDirectory
        public abstract DirectoryProperty getGeneratedResourcesDirectory();

        @TaskAction
        public void doTask() throws IOException {
            MTPluginConfig mtpConfig = ((MTPluginConfig)this.getProject().getExtensions().getByType(MTPluginConfig.class)).validate();
            JSONObject json = mtpConfig.getConfigJson((Integer)this.getMinAndroidVersion().get());
            json.put("timestamp", this.getTimestamp().get());
            File file = ((RegularFile)this.getGeneratedResourcesDirectory().file("MTPluginConfig.json").get()).getAsFile();
            FileUtils.writeStringToFile((File)file, (String)json.toString(2), (Charset)StandardCharsets.UTF_8);
        }
    }

    public static abstract class PackMTPFileTask
    extends DefaultTask {
        @Input
        public abstract Property<Integer> getMinAndroidVersion();

        @InputDirectory
        public abstract DirectoryProperty getInputDirectory();

        @OutputDirectory
        public abstract DirectoryProperty getOutputDirectory();

        @TaskAction
        public void doTask() throws IOException {
            MTPluginConfig mtpConfig = ((MTPluginConfig)this.getProject().getExtensions().getByType(MTPluginConfig.class)).validate();
            JSONObject config = mtpConfig.getConfigJson((Integer)this.getMinAndroidVersion().get());
            HashSet<String> excludedFiles = new HashSet<String>();
            ArrayList<String> excludedDirs = new ArrayList<String>();
            for (Object value : config.getJSONArray("excludedFiles")) {
                String path = value.toString();
                if (path.endsWith("/")) {
                    excludedDirs.add(path);
                    continue;
                }
                excludedFiles.add(path);
            }
            File outputDir = (File)this.getOutputDirectory().getAsFile().get();
            File outputFile = new File(outputDir, mtpConfig.getPluginID() + ".mtp");
            FileUtils.forceMkdir((File)outputDir);
            File inputDir = (File)this.getInputDirectory().getAsFile().get();
            File metaFile = new File(inputDir, "output-metadata.json");
            JSONObject metaJson = new JSONObject(FileUtils.readFileToString((File)metaFile, (Charset)StandardCharsets.UTF_8));
            String apkFilename = metaJson.getJSONArray("elements").getJSONObject(0).getString("outputFile");
            try (ZipFile zipFile = new ZipFile(new File(inputDir, apkFilename));
                 ZipArchiveOutputStream zos = new ZipArchiveOutputStream(outputFile);){
                JSONObject manifest = config.getJSONObject("manifest");
                ZipArchiveEntry manifestEntry = new ZipArchiveEntry("manifest.json");
                zos.putArchiveEntry(manifestEntry);
                zos.write(manifest.toString(2).getBytes(StandardCharsets.UTF_8));
                excludedFiles.add(manifestEntry.getName());
                assert (manifest.getBoolean("dexMode"));
                List<ZipArchiveEntry> dexEntries = MTPlugin.getDexEntries(zipFile);
                dexEntries.stream().map(ZipArchiveEntry::getName).forEach(excludedFiles::add);
                if (dexEntries.size() == 1) {
                    ZipArchiveEntry dexEntry = dexEntries.get(0);
                    zos.addRawArchiveEntry(dexEntry, zipFile.getRawInputStream(dexEntry));
                } else {
                    ArrayList classes = new ArrayList();
                    for (ZipArchiveEntry dexEntry : dexEntries) {
                        DexBackedDexFile dexFile = DexBackedDexFile.fromInputStream(null, (InputStream)new BufferedInputStream(zipFile.getInputStream(dexEntry)));
                        classes.addAll(dexFile.getClasses());
                    }
                    Opcodes opcodes = Opcodes.forApi((int)((Integer)this.getMinAndroidVersion().get()));
                    DexPool dexPool = new DexPool(opcodes);
                    int currentDexIndex = 1;
                    int size = classes.size();
                    for (int i = 0; i < size; ++i) {
                        ClassDef classDef = (ClassDef)classes.get(i);
                        dexPool.internClass(classDef);
                        if (!dexPool.hasOverflowed()) continue;
                        dexPool = new DexPool(opcodes);
                        for (int j = 0; j < i; ++j) {
                            dexPool.internClass((ClassDef)classes.get(j));
                        }
                        MTPlugin.writeDex(zos, dexPool, currentDexIndex++);
                        dexPool = new DexPool(opcodes);
                        dexPool.internClass(classDef);
                    }
                    MTPlugin.writeDex(zos, dexPool, currentDexIndex);
                }
                Enumeration entries = zipFile.getEntriesInPhysicalOrder();
                while (entries.hasMoreElements()) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                    String name = entry.getName();
                    if (name.endsWith("/") || excludedFiles.contains(name)) continue;
                    if (excludedDirs.stream().anyMatch(name::startsWith)) continue;
                    if (entry.getMethod() != 0) {
                        zos.addRawArchiveEntry(entry, zipFile.getRawInputStream(entry));
                        continue;
                    }
                    zos.putArchiveEntry(new ZipArchiveEntry(entry.getName()));
                    IOUtils.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)zos);
                }
            }
        }
    }
}

