/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;

class ZipMaker
implements Closeable {
    private final ZipParameters zipParameters = new ZipParameters();
    private final ZipOutputStream zos;
    private boolean hasNotClosedEntry;

    ZipMaker(File file) throws IOException {
        this.zipParameters.setCompressionMethod(CompressionMethod.DEFLATE);
        this.zipParameters.setCompressionLevel(CompressionLevel.ULTRA);
        this.zos = new ZipOutputStream((OutputStream)new FileOutputStream(file));
    }

    public void putNextEntry(String name) throws IOException {
        this.closeEntry();
        this.zipParameters.setFileNameInZip(name);
        this.zos.putNextEntry(this.zipParameters);
        this.hasNotClosedEntry = true;
    }

    public void write(byte[] data) throws IOException {
        this.zos.write(data);
    }

    public void write(byte[] data, int off, int len) throws IOException {
        this.zos.write(data, off, len);
    }

    public void closeEntry() throws IOException {
        if (this.hasNotClosedEntry) {
            this.zos.closeEntry();
            this.hasNotClosedEntry = false;
        }
    }

    public void copyZipEntry(FileHeader ze, ZipFile zipFile) throws IOException {
        this.putNextEntry(ze.getFileName());
        try (ZipInputStream is = zipFile.getInputStream(ze);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                this.zos.write(buf, 0, len);
            }
        }
        this.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.closeEntry();
        this.zos.close();
    }
}

