/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

import bin.mt.plugin.MTPluginConfig;
import bin.mt.plugin.ZipMaker;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.writer.io.DexDataStore;
import com.android.tools.smali.dexlib2.writer.io.MemoryDataStore;
import com.android.tools.smali.dexlib2.writer.pool.DexPool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.json.JSONObject;

public class MTPlugin
implements Plugin<Project> {
    static final int PLUGIN_SDK_VERSION = 3;
    static final String LIB_PLUGIN_PUSHER = "bin.mt.plugin:pusher:1.0.0-alpha2";
    static final String LIB_PLUGIN_API = "bin.mt.plugin:api:3.0.0-alpha4";

    public void apply(@Nonnull Project project) {
        if (!project.getPlugins().hasPlugin("com.android.application")) {
            throw new IllegalStateException("Packer plugin can only be applied to Android Application projects");
        }
        project.getDependencies().add("implementation", (Object)LIB_PLUGIN_PUSHER);
        project.getDependencies().add("compileOnly", (Object)LIB_PLUGIN_API);
        project.getExtensions().create("mtPlugin", MTPluginConfig.class, new Object[0]);
        ApplicationAndroidComponentsExtension appExtension = (ApplicationAndroidComponentsExtension)project.getExtensions().getByType(ApplicationAndroidComponentsExtension.class);
        appExtension.onVariants(appExtension.selector().all(), variant -> {
            switch (variant.getName()) {
                case "debug": {
                    this.onDebugVariant(project, (ApplicationVariant)variant);
                    break;
                }
                case "release": {
                    this.onReleaseVariant(project, (ApplicationVariant)variant);
                }
            }
        });
    }

    private void onDebugVariant(Project project, ApplicationVariant variant) {
        TaskProvider generateDebugMTPluginConfigTask = project.getTasks().register("generateDebugMTPluginConfig", GenerateConfigFileTask.class, task -> {
            int minSdkVersion = variant.getMinSdk().getApiLevel();
            if (minSdkVersion < 24) {
                Integer level;
                Object deviceApiLevel = project.findProperty("android.injected.build.api");
                if (deviceApiLevel instanceof String) {
                    String str = (String)deviceApiLevel;
                    deviceApiLevel = Integer.parseInt(str);
                }
                if (deviceApiLevel instanceof Integer && (level = (Integer)deviceApiLevel) >= 24) {
                    minSdkVersion = 24;
                }
            }
            task.getMinAndroidVersion().set((Object)minSdkVersion);
        });
        Objects.requireNonNull(variant.getSources().getResources()).addGeneratedSourceDirectory(generateDebugMTPluginConfigTask, GenerateConfigFileTask::getGeneratedResourcesDirectory);
    }

    private void onReleaseVariant(Project project, ApplicationVariant variant) {
        project.afterEvaluate(p -> project.getTasks().register("packageReleaseMtp", PackMTPFileTask.class, task -> {
            Task packageApkTask = (Task)project.getTasks().named("packageRelease").get();
            task.dependsOn(new Object[]{packageApkTask});
            task.setGroup("mt-plugin");
            task.setDescription("Generate MT plugin installation package file");
            task.getMinAndroidVersion().set((Object)variant.getMinSdk().getApiLevel());
            task.getInputDirectory().set(packageApkTask.getOutputs().getFiles().filter(file -> file.getName().equals("output-metadata.json")).getSingleFile().getParentFile());
            task.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("outputs/mt-plugin"));
        }));
    }

    private static List<FileHeader> getDexEntries(ZipFile zipFile) throws IOException {
        String name;
        FileHeader entry;
        int index = 0;
        if ((entry = zipFile.getFileHeader(name = MTPlugin.getDexName(++index))) == null) {
            throw new IOException("Entry not found: " + name);
        }
        ArrayList<FileHeader> list = new ArrayList<FileHeader>();
        while (entry != null) {
            list.add(entry);
            name = MTPlugin.getDexName(++index);
            entry = zipFile.getFileHeader(name);
        }
        return list;
    }

    private static String getDexName(int index) {
        if (index <= 0) {
            throw new IllegalArgumentException();
        }
        if (index == 1) {
            return "classes.dex";
        }
        return "classes" + index + ".dex";
    }

    public static abstract class GenerateConfigFileTask
    extends DefaultTask {
        @Input
        public abstract Property<Integer> getMinAndroidVersion();

        @OutputDirectory
        public abstract DirectoryProperty getGeneratedResourcesDirectory();

        @TaskAction
        public void doTask() throws IOException {
            MTPluginConfig mtpConfig = ((MTPluginConfig)this.getProject().getExtensions().getByType(MTPluginConfig.class)).validate();
            JSONObject json = mtpConfig.getConfigJson((Integer)this.getMinAndroidVersion().get(), false);
            File file = ((RegularFile)this.getGeneratedResourcesDirectory().file("MTPluginConfig.json").get()).getAsFile();
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(json.toString(2).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static abstract class PackMTPFileTask
    extends DefaultTask {
        @Input
        public abstract Property<Integer> getMinAndroidVersion();

        @InputDirectory
        public abstract DirectoryProperty getInputDirectory();

        @OutputDirectory
        public abstract DirectoryProperty getOutputDirectory();

        @TaskAction
        public void doTask() throws IOException {
            MTPluginConfig mtpConfig = ((MTPluginConfig)this.getProject().getExtensions().getByType(MTPluginConfig.class)).validate();
            JSONObject config = mtpConfig.getConfigJson((Integer)this.getMinAndroidVersion().get(), true);
            HashSet<String> excludedFiles = new HashSet<String>();
            ArrayList<String> excludedDirs = new ArrayList<String>();
            for (Object value : config.getJSONArray("excludedFiles")) {
                String path = value.toString();
                if (path.endsWith("/")) {
                    excludedDirs.add(path);
                    continue;
                }
                excludedFiles.add(path);
            }
            Set excludedClasses = config.getJSONArray("excludedClasses").toList().stream().map(Object::toString).collect(Collectors.toSet());
            File outputDir = (File)this.getOutputDirectory().getAsFile().get();
            File outputFile = new File(outputDir, mtpConfig.getPluginID() + ".mtp");
            outputDir.mkdirs();
            File inputDir = (File)this.getInputDirectory().getAsFile().get();
            File metaFile = new File(inputDir, "output-metadata.json");
            JSONObject metaJson = new JSONObject(Files.readString(metaFile.toPath(), StandardCharsets.UTF_8));
            String apkFilename = metaJson.getJSONArray("elements").getJSONObject(0).getString("outputFile");
            try (ZipFile zipFile = new ZipFile(new File(inputDir, apkFilename));
                 ZipMaker zipMaker = new ZipMaker(outputFile);){
                JSONObject manifest = config.getJSONObject("manifest");
                zipMaker.putNextEntry("manifest.json");
                zipMaker.write(manifest.toString(2).getBytes(StandardCharsets.UTF_8));
                excludedFiles.add("manifest.json");
                if (manifest.optBoolean("dexMode")) {
                    for (FileHeader dexEntry : MTPlugin.getDexEntries(zipFile)) {
                        excludedFiles.add(dexEntry.getFileName());
                        if (excludedClasses.isEmpty()) {
                            zipMaker.copyZipEntry(dexEntry, zipFile);
                            continue;
                        }
                        DexBackedDexFile dexFile = DexBackedDexFile.fromInputStream(null, (InputStream)new BufferedInputStream((InputStream)zipFile.getInputStream(dexEntry)));
                        if (dexFile.getClasses().stream().anyMatch(classDef -> excludedClasses.contains(classDef.getType()))) {
                            DexPool dexBuilder = new DexPool(dexFile.getOpcodes());
                            for (DexBackedClassDef classDef2 : dexFile.getClasses()) {
                                if (excludedClasses.contains(classDef2.getType())) continue;
                                dexBuilder.internClass((ClassDef)classDef2);
                            }
                            MemoryDataStore dataStore = new MemoryDataStore();
                            dexBuilder.writeTo((DexDataStore)dataStore);
                            zipMaker.putNextEntry(dexEntry.getFileName());
                            zipMaker.write(dataStore.getBuffer(), 0, dataStore.getSize());
                            continue;
                        }
                        zipMaker.copyZipEntry(dexEntry, zipFile);
                    }
                }
                block13: for (FileHeader entry : zipFile.getFileHeaders()) {
                    String name = entry.getFileName();
                    if (name.endsWith("/") || excludedFiles.contains(name)) continue;
                    int size = excludedDirs.size();
                    for (int i = 0; i < size; ++i) {
                        if (name.startsWith((String)excludedDirs.get(i))) continue block13;
                    }
                    zipMaker.copyZipEntry(entry, zipFile);
                }
            }
        }
    }
}

