package bin.mt.plugin;

import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

class ZipMaker implements Closeable {
    private final ZipParameters zipParameters = new ZipParameters();
    private final ZipOutputStream zos;
    private boolean hasNotClosedEntry;

    ZipMaker(File file) throws IOException {
        zipParameters.setCompressionMethod(CompressionMethod.DEFLATE);
        zipParameters.setCompressionLevel(CompressionLevel.ULTRA);
        zos = new ZipOutputStream(new FileOutputStream(file));
    }

    public void putNextEntry(String name) throws IOException {
        closeEntry();
        zipParameters.setFileNameInZip(name);
        zos.putNextEntry(zipParameters);
        hasNotClosedEntry = true;
    }

    public void write(byte[] data) throws IOException {
        zos.write(data);
    }

    public void write(byte[] data, int off, int len) throws IOException {
        zos.write(data, off, len);
    }

    public void closeEntry() throws IOException {
        if (hasNotClosedEntry) {
            zos.closeEntry();
            hasNotClosedEntry = false;
        }
    }

    public void copyZipEntry(FileHeader ze, ZipFile zipFile) throws IOException {
        putNextEntry(ze.getFileName());
        try (var is = zipFile.getInputStream(ze)) {
            byte[] buf = new byte[1024];
            int len;
            while((len = is.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
        }
        closeEntry();
    }

    @Override
    public void close() throws IOException {
        closeEntry();
        zos.close();
    }
}
