/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

import bin.mt.plugin.MTPluginConfig;
import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.writer.io.DexDataStore;
import com.android.tools.smali.dexlib2.writer.io.MemoryDataStore;
import com.android.tools.smali.dexlib2.writer.pool.DexPool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class MTPluginPackingTask
extends DefaultTask {
    @Input
    public abstract Property<Integer> getMinAndroidVersion();

    @OutputFile
    public abstract RegularFileProperty getReleaseApkFile();

    @OutputFile
    public abstract RegularFileProperty getOutputMtpFile();

    @OutputFile
    public abstract RegularFileProperty getOutputPackedMtpFile();

    @OutputFile
    public abstract RegularFileProperty getOutputPackedPusherConf();

    @TaskAction
    public void packageFiles() throws IOException {
        MTPluginConfig mtpConfig = (MTPluginConfig)this.getProject().getExtensions().getByType(MTPluginConfig.class);
        try (FileOutputStream is = new FileOutputStream(((RegularFile)this.getOutputPackedPusherConf().get()).getAsFile());){
            ((OutputStream)is).write(("mtPackageName=" + mtpConfig.getPushTarget()).getBytes(StandardCharsets.UTF_8));
        }
        File outputZip = ((RegularFile)this.getOutputMtpFile().get()).getAsFile();
        outputZip.getParentFile().mkdirs();
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setCompressionMethod(CompressionMethod.DEFLATE);
        zipParameters.setCompressionLevel(CompressionLevel.ULTRA);
        try (ZipFile zipFile = new ZipFile(((RegularFile)this.getReleaseApkFile().get()).getAsFile());
             ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(outputZip));){
            zipParameters.setFileNameInZip("manifest.json");
            zos.putNextEntry(zipParameters);
            zos.write(mtpConfig.toJson().replace("{minAndroidVersion}", ((Integer)this.getMinAndroidVersion().get()).toString()).getBytes(StandardCharsets.UTF_8));
            zos.closeEntry();
            ArrayList<Object> list = new ArrayList<Object>();
            ArrayList<FileHeader> dexList = new ArrayList<FileHeader>();
            HashMap<String, FileHeader> temp = new HashMap<String, FileHeader>();
            for (FileHeader fileHeader : zipFile.getFileHeaders()) {
                String name = fileHeader.getFileName();
                if (name.startsWith("META-INF/") || name.startsWith("lib/") || name.equals("AndroidManifest.xml") || name.equals("resources.arsc") || name.equals("pusher.conf") || name.equals("pusher-install.mtp")) continue;
                if (name.startsWith("classes") && name.endsWith(".dex")) {
                    temp.put(name, fileHeader);
                    continue;
                }
                list.add(fileHeader);
            }
            if (!temp.containsKey("classes.dex")) {
                throw new IOException("classes.dex not found");
            }
            int i = 1;
            while (true) {
                Object dexName = i == 1 ? "classes.dex" : "classes" + i + ".dex";
                ++i;
                FileHeader dexEntry = (FileHeader)temp.remove(dexName);
                if (dexEntry == null) break;
                dexList.add(dexEntry);
            }
            list.addAll(temp.values());
            zipParameters.setFileNameInZip("classes.dex");
            zos.putNextEntry(zipParameters);
            DexPool dexBuilder = new DexPool(Opcodes.forApi((int)21));
            for (FileHeader dexEntry : dexList) {
                DexBackedDexFile dexBackedDexFile = DexBackedDexFile.fromInputStream(null, (InputStream)new BufferedInputStream((InputStream)zipFile.getInputStream(dexEntry)));
                for (DexBackedClassDef classDef : dexBackedDexFile.getClasses()) {
                    int accessFlags;
                    String classType = classDef.getType();
                    if (classType.equals("Lbin/mt/plugin/push/PusherActivity;") || classType.endsWith("/R;") && AccessFlags.PUBLIC.isSet(accessFlags = classDef.getAccessFlags()) && AccessFlags.FINAL.isSet(accessFlags) && "Ljava/lang/Object;".equals(classDef.getSuperclass()) && classDef.getInterfaces().isEmpty() && MTPluginPackingTask.isEmpty(classDef.getInstanceFields()) && MTPluginPackingTask.isEmpty(classDef.getStaticFields()) && MTPluginPackingTask.isEmpty(classDef.getVirtualMethods()) && MTPluginPackingTask.size(classDef.getDirectMethods()) == 1) continue;
                    dexBuilder.internClass((ClassDef)classDef);
                }
            }
            MemoryDataStore dataStore = new MemoryDataStore();
            dexBuilder.writeTo((DexDataStore)dataStore);
            zos.write(dataStore.getBuffer(), 0, dataStore.getSize());
            zos.closeEntry();
            for (FileHeader fileHeader : list) {
                zipParameters.setFileNameInZip(fileHeader.getFileName());
                zos.putNextEntry(zipParameters);
                MTPluginPackingTask.copy((InputStream)zipFile.getInputStream(fileHeader), (OutputStream)zos);
                zos.closeEntry();
            }
        }
        try (FileInputStream is = new FileInputStream(outputZip);
             FileOutputStream os = new FileOutputStream(((RegularFile)this.getOutputPackedMtpFile().get()).getAsFile());){
            MTPluginPackingTask.copy(is, os);
        }
    }

    private static boolean isEmpty(Iterable<?> iterable) {
        return !iterable.iterator().hasNext();
    }

    public static int size(Iterable<?> iterable) {
        int size = 0;
        for (Object ignored : iterable) {
            ++size;
        }
        return size;
    }

    private static void copy(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            os.write(buf, 0, len);
        }
    }
}

