/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

public class MTPluginConfig {
    private String pushTarget = "auto";
    private String pluginID;
    private int versionCode = 1;
    private String versionName = "null";
    private String name;
    private String description;
    private String mainPreference;
    private String[] interfaces;

    public String getPushTarget() {
        return this.pushTarget;
    }

    public void setPushTarget(String pushTarget) {
        this.pushTarget = pushTarget;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public void setPluginID(String pluginID) {
        this.pluginID = pluginID;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(int versionCode) {
        this.versionCode = versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMainPreference() {
        return this.mainPreference;
    }

    public void setMainPreference(String mainPreference) {
        this.mainPreference = mainPreference;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void validate() {
        if (this.pluginID == null || this.pluginID.trim().isEmpty()) {
            throw new IllegalArgumentException("mtPlugin.pluginID is required and cannot be empty");
        }
        if (!this.pluginID.matches("^[a-zA-Z0-9_.]+$")) {
            throw new IllegalArgumentException("mtPlugin.pluginID can only contain letters, numbers, underscores and dots");
        }
        if (this.versionCode <= 0) {
            throw new IllegalArgumentException("mtPlugin.versionCode must be greater than 0");
        }
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("mtPlugin.name is required and cannot be empty");
        }
        if (this.description == null) {
            throw new IllegalArgumentException("mtPlugin.description is required");
        }
    }

    public String toJson() {
        this.validate();
        StringBuilder json = new StringBuilder();
        json.append("{\n");
        json.append("  minAndroidVersion: {minAndroidVersion}").append(",\n");
        json.append("  pluginSdkVersion: ").append(3).append(",\n");
        json.append("  pluginID: ").append("\"").append(this.escapeJson(this.pluginID)).append("\"").append(",\n");
        json.append("  versionCode: ").append(this.versionCode).append(",\n");
        json.append("  versionName: ").append("\"").append(this.escapeJson(this.versionName)).append("\"").append(",\n");
        json.append("  name: ").append("\"").append(this.escapeJson(this.name)).append("\"").append(",\n");
        json.append("  description: ").append("\"").append(this.escapeJson(this.description)).append("\"").append(",\n");
        if (this.mainPreference != null && !this.mainPreference.isEmpty()) {
            json.append("  mainPreference: ").append("\"").append(this.escapeJson(this.mainPreference)).append("\"").append(",\n");
        }
        if (this.interfaces != null && this.interfaces.length > 0) {
            json.append("  interfaces: ");
            json.append("[\n");
            for (int i = 0; i < this.interfaces.length; ++i) {
                json.append("    \"").append(this.escapeJson(this.interfaces[i])).append("\"");
                if (i < this.interfaces.length - 1) {
                    json.append(",");
                }
                json.append("\n");
            }
            json.append("  ]").append(",\n");
        }
        json.append("  dexMode: true").append("\n");
        json.append("}");
        return json.toString();
    }

    private String escapeJson(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder escaped = new StringBuilder();
        block9: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    escaped.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    escaped.append("\\b");
                    continue block9;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block9;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block9;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block9;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block9;
                }
                default: {
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }
}

