/*
 * Decompiled with CFR 0.152.
 */
package bin.mt.plugin;

import bin.mt.plugin.MTPluginConfig;
import bin.mt.plugin.MTPluginPackingTask;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;

public class MTPlugin
implements Plugin<Project> {
    static final int PLUGIN_SDK_VERSION = 3;
    static final String LIB_PLUGIN_PUSHER = "bin.mt.plugin:pusher:1.0.0-alpha";
    static final String LIB_PLUGIN_API = "bin.mt.plugin:api:3.0.0-alpha4";

    public void apply(@Nonnull Project project) {
        if (!project.getPlugins().hasPlugin("com.android.application")) {
            throw new IllegalStateException("Packer plugin can only be applied to Android Application projects");
        }
        project.getDependencies().add("implementation", (Object)LIB_PLUGIN_PUSHER);
        project.getDependencies().add("compileOnly", (Object)LIB_PLUGIN_API);
        project.getExtensions().create("mtPlugin", MTPluginConfig.class, new Object[0]);
        project.afterEvaluate(this::afterEvaluate);
    }

    private void afterEvaluate(@Nonnull Project project) {
        int minSdk;
        Object extension = project.getExtensions().findByName("android");
        if (extension == null) {
            throw new RuntimeException("Can not find the Android Extension");
        }
        try {
            Object sourceSets = extension.getClass().getMethod("getSourceSets", new Class[0]).invoke(extension, new Object[0]);
            Object mainSourceSet = sourceSets.getClass().getMethod("getByName", String.class).invoke(sourceSets, "main");
            Object resources = mainSourceSet.getClass().getMethod("getResources", new Class[0]).invoke(mainSourceSet, new Object[0]);
            resources.getClass().getMethod("srcDir", Object.class).invoke(resources, "build/intermediates/mt-plugin/resources");
            Object defaultConfig = extension.getClass().getMethod("getDefaultConfig", new Class[0]).invoke(extension, new Object[0]);
            minSdk = (Integer)defaultConfig.getClass().getMethod("getMinSdk", new Class[0]).invoke(defaultConfig, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to configure Android source sets", e);
        }
        this.registerPackageTask(project, minSdk);
    }

    private void registerPackageTask(@Nonnull Project project, int minSdk) {
        TaskProvider packageTask = project.getTasks().register("packagePlugin", MTPluginPackingTask.class, task -> {
            task.setGroup("mt-plugin");
            task.setDescription("MT Manager Plugin Development");
            MTPluginConfig config = (MTPluginConfig)project.getExtensions().getByType(MTPluginConfig.class);
            config.validate();
            task.getMinAndroidVersion().set((Object)minSdk);
            task.getReleaseApkFile().set(project.file((Object)"build/intermediates/apk/release/app-release-unsigned.apk"));
            task.getOutputPackedPusherConf().set(project.file((Object)"build/intermediates/mt-plugin/resources/pusher.conf"));
            task.getOutputPackedMtpFile().set(project.file((Object)"build/intermediates/mt-plugin/resources/pusher-install.mtp"));
            task.getOutputMtpFile().set(project.file((Object)("build/outputs/mt-plugin/" + config.getPluginID() + ".mtp")));
        });
        packageTask.configure(task -> task.dependsOn(new Object[]{project.getTasks().named("assembleRelease")}));
        project.getTasks().named("processDebugJavaRes").configure(task -> task.dependsOn(new Object[]{packageTask}));
    }
}

