package bin.mt.plugin.api.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 插件内部服务提供发现机制，不对外提供功能
 */
public class ServiceLoader {
    private static final Map<Class<?>, Object> IMPL_MAP = new HashMap<>();

    public static <T> void register(Class<T> clazz, T impl) {
        if (impl != null && clazz.isInstance(impl) && impl.getClass().getClassLoader() == ServiceLoader.class.getClassLoader() && !IMPL_MAP.containsKey(clazz)) {
            IMPL_MAP.put(clazz, impl);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static <T> T get(Class<T> clazz) {
        //noinspection unchecked
        return (T) Objects.requireNonNull(IMPL_MAP.get(clazz));
    }

}
