package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginFrameLayout;

/**
 * 插件帧布局构建器接口
 * <p>
 * 帧布局是一种将子View叠加显示的容器布局，子View默认置于左上角，可通过layoutGravity单独设置对齐方式，
 * 后添加的View会覆盖在先添加的View之上。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * pluginUIBuilder
 *     .addFrameLayout().children(builder -> builder
 *         .addTextView().text("文字1").layoutGravity(Gravity.LEFT)
 *         .addTextView().text("文字2").layoutGravity(Gravity.RIGHT)
 *     )
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseViewGroupBuilder
 * @see PluginFrameLayout
 */
public interface PluginFrameLayoutBuilder extends PluginBaseViewGroupBuilder<PluginFrameLayoutBuilder> {

}