package bin.mt.plugin.api.ui;

/**
 * 插件视图容器接口
 * <p>
 * 这是插件化UI框架中所有容器类视图组件的基础接口，继承自PluginView。
 * PluginViewGroup代表可以包含其他子View的容器视图，目前有PluginLinearLayout和PluginRadioGroup。
 * </p>
 *
 * @see PluginView
 * @see PluginLinearLayout
 * @see PluginRadioGroup
 */
public interface PluginViewGroup extends PluginView {

    /**
     * 获取子View的数量
     *
     * @return 容器中子View的总数
     */
    int getChildCount();

    /**
     * 根据索引获取子View
     *
     * @param index 子View的索引位置，从0开始
     * @return 指定位置的子View对象
     * @throws IndexOutOfBoundsException 如果索引超出范围
     */
    PluginView getChildAt(int index);

}
