package bin.mt.plugin.api.ui;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.List;

/**
 * 插件下拉选择框接口
 *
 * @see bin.mt.plugin.api.ui.builder.PluginSpinnerBuilder
 */
public interface PluginSpinner extends PluginView {

    /**
     * 设置下拉框的选项列表
     * <p>
     * 设置用户可以选择的选项数据。列表中的对象如果不是CharSequence类型，
     * 会调用toString()方法转换为字符串进行显示。
     * </p>
     *
     * @param items 选项数据列表，支持任意对象类型
     * @see CharSequence
     */
    void setItems(@NonNull List<?> items);

    /**
     * 设置选项选择监听器
     * <p>
     * 当用户选择某个选项时会触发此监听器回调，可以在回调中处理选择逻辑。
     * </p>
     *
     * @param listener 选择监听器，接收下拉框实例和选中位置索引
     */
    void setOnItemSelectedListener(@Nullable OnItemSelectedListener listener);

    /**
     * 设置当前选中的选项位置
     *
     * @param position 选项位置索引，从0开始
     */
    void setSelection(int position);

    /**
     * 获取当前选中的选项位置
     *
     * @return 选中选项的位置索引，如果没有选中则返回-1
     */
    int getSelection();

    /**
     * 获取当前选中的选项对象
     *
     * @return 选中的选项对象，如果没有选中则返回null
     */
    Object getSelectedItem();

    /**
     * 根据位置获取选项对象
     *
     * @param position 选项位置索引
     * @return 指定位置的选项对象
     */
    Object getItem(int position);

    /**
     * 获取选项总数
     *
     * @return 选项列表的大小
     */
    int getCount();

    /**
     * 选项选择监听器接口
     * 用于监听用户的选择操作
     */
    interface OnItemSelectedListener {

        /**
         * 当用户选择某个选项时的回调方法
         *
         * @param spinner  触发选择事件的下拉框
         * @param position 被选中选项的位置索引
         */
        void onItemSelected(@NonNull PluginSpinner spinner, int position);

    }
}
