package bin.mt.plugin.api.ui;

/**
 * 插件单选按钮接口
 *
 * @see bin.mt.plugin.api.ui.builder.PluginRadioButtonBuilder
 */
public interface PluginRadioButton extends PluginCompoundButton {

    /**
     * 获取当前单选按钮在PluginRadioGroup中的位置
     * <p>
     * 这里的位置仅统计添加的PluginRadioButton，添加其它类型的组件不会产生影响，例如：
     * <pre>{@code
     * pluginRadioGroupBuilder
     *     .addRadioButton() // 位置为0
     *     .addTextView()    // 不影响后续位置
     *     .addRadioButton() // 位置为1
     * }</pre>
     *
     * @return 当前单选按钮在PluginRadioGroup中的位置，从0开始，如果未添加到PluginRadioGroup则为-1
     */
    int getPositionInRadioGroup();

}
