/*******************************************************************************
 * Copyright (c) 2015 EclipseSource.
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 ******************************************************************************/
package bin.mt.json;

import java.io.Writer;


/**
 * 控制 JSON 输出的格式化方式。使用可用的常量之一
 */
public abstract class WriterConfig {

    /**
     * 以紧凑形式写入 JSON，不包含任何额外的空白字符。这是默认设置
     */
    public static WriterConfig MINIMAL = new WriterConfig() {
        @Override
        JSONWriter createWriter(Writer writer) {
            return new JSONWriter(writer);
        }
    };

    /**
     * 以格式化形式写入 JSON，每个值占据单独一行，使用两个空格作为缩进
     */
    public static WriterConfig PRETTY_PRINT = PrettyPrint.indentWithSpaces(2);

    abstract JSONWriter createWriter(Writer writer);

}
