package bin.mt.plugin.api.util;

import androidx.annotation.Nullable;

/**
 * 通用异步操作回调接口
 * <p>
 * 用于处理异步操作的成功或失败结果
 */
public interface ResultCallback {
    /**
     * 错误消息常量：不支持的操作
     */
    String ERROR_UNSUPPORTED_OPERATION = "Unsupported operation";

    /**
     * 错误消息常量：操作已取消
     */
    String ERROR_OPERATION_CANCELED = "Operation cancelled";

    /**
     * 操作成功时调用
     */
    void onSuccess();

    /**
     * 操作失败时调用
     *
     * @param error 错误信息，可能为null
     */
    void onFailure(@Nullable String error);
}