package bin.mt.plugin.api.ui;

/**
 * 插件按钮接口
 *
 * @see bin.mt.plugin.api.ui.builder.PluginButtonBuilder
 */
public interface PluginButton extends PluginTextView {
    /**
     * 获取当前按钮的样式（样式在构建时设置，构建完成后无法修改）
     *
     * @return 按钮样式枚举值
     * @see Style
     */
    Style getStyle();

    /**
     * 按钮风格枚举
     */
    enum Style {
        /**
         * 默认风格 - 系统默认按钮样式
         */
        DEFAULT,

        /**
         * 填充风格 - 使用colorAccent作为背景色的实心按钮
         */
        FILLED,

        /**
         * 轮廓风格 - 带有colorAccent颜色边框的空心按钮
         */
        OUTLINED
    }
}
