package bin.mt.plugin.api.ui.menu;

import android.graphics.drawable.Drawable;

/**
 * 插件子菜单接口
 * <p>
 * 继承自 PluginMenu，表示一个包含其他菜单项的子菜单
 * 子菜单本身也作为一个菜单项存在于父菜单中
 */
public interface PluginSubMenu extends PluginMenu {

    /**
     * 设置子菜单的图标
     *
     * @param icon 图标Drawable
     * @return 当前子菜单实例，支持链式调用
     */
    PluginSubMenu setIcon(Drawable icon);

    /**
     * 获取代表此子菜单的菜单项
     * <p>
     * 子菜单在父菜单中作为一个菜单项显示，此方法返回该菜单项对象
     *
     * @return 代表此子菜单的菜单项
     */
    PluginMenuItem getItem();

}
