package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginCheckBox;

/**
 * 插件复选框构建器接口
 * <p>
 * 复选框继承了复合按钮的所有功能，包括状态管理、事件监听等，
 * 通常用于设置选项中的多项选择、设置开关等场景。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * pluginUIBuilder
 *     .addCheckBox("matchCase").text("区分大小写").checked(false)
 *     .addCheckBox("regex").text("正则表达式").checked(false)
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseCompoundButtonBuilder
 * @see PluginCheckBox
 */
public interface PluginCheckBoxBuilder extends PluginBaseCompoundButtonBuilder<PluginCheckBoxBuilder> {

}