package bin.mt.plugin.api.drawable;

import android.graphics.drawable.Drawable;

import androidx.annotation.NonNull;

import bin.mt.plugin.api.util.ServiceLoader;

/**
 * 获取内置的Material图标，所有图标大小均为24x24dp
 * <p>
 * 查看完整图标列表请访问：<a href="https://mt2.cn/icons">Material Icons</a>
 */
public final class MaterialIcons {

    /**
     * 根据名称获取Material图标（filled风格）
     * <p>
     * 查看完整图标列表请访问：<a href="https://mt2.cn/icons">Material Icons</a>
     *
     * @param name 图标名称，例如："home"、"search"、"settings"等
     * @return 图标Drawable，大小为24x24dp
     * @throws IllegalArgumentException 当找不到对应名称的图标时抛出
     */
    @NonNull
    public static Drawable get(String name) {
        return ServiceLoader.get(Impl.class).get(name);
    }

    /**
     * 根据名称获取Material图标（outlined风格）
     * <p>
     * 查看完整图标列表请访问：<a href="https://mt2.cn/icons">Material Icons</a>
     *
     * @param name 图标名称，例如："home"、"search"、"settings"等
     * @return 图标Drawable，大小为24x24dp
     * @throws IllegalArgumentException 当找不到对应名称的图标时抛出
     */
    @NonNull
    public static Drawable getOutlined(String name) {
        return ServiceLoader.get(Impl.class).getOutlined(name);
    }

    private MaterialIcons() {
    }

    interface Impl {
        Drawable get(String name);

        Drawable getOutlined(String name);
    }

}
