package bin.mt.plugin.api.util;

/**
 * 消费者函数式接口
 * <p>
 * 表示接受单个输入参数但不返回结果的操作
 * <p>
 * 这是一个函数式接口，其函数方法是 {@link #accept(Object)}
 *
 * @param <T> 操作的输入类型
 */
public interface Consumer<T> {

    /**
     * 对给定的参数执行此操作
     *
     * @param t 输入参数
     */
    void accept(T t);

}