package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginView;

/**
 * 插件普通视图构建器接口
 * <p>
 * 普通视图（View）继承了所有基础视图属性设置能力，包括ID、尺寸、边距、背景、事件监听等。
 * 可以用它实现添加分割线、占据一块空白空间等功能。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * pluginUIBuilder
 *     .addView()
 *     .id("divider")
 *     .widthMatchParent()
 *     .height(1)
 *     .backgroundColor(pluginUI.colorDivider())
 *     .marginVerticalDp(12)
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseViewBuilder
 * @see PluginView
 */
public interface PluginViewBuilder extends PluginBaseViewBuilder<PluginViewBuilder> {
}
