package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginSwitchButton;

/**
 * 插件开关按钮构建器接口
 * <p>
 * 开关按钮是一个具有开启/关闭两种状态的UI组件，
 * 通常用于设置选项的启用/禁用状态。外观类似物理开关，提供直观的开关体验。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * pluginViewBuilder
 *     .addSwitchButton("matchCase").text("区分大小写").checked(false)
 *     .addSwitchButton("regex").text("正则表达式").checked(false)
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseCompoundButtonBuilder
 * @see PluginSwitchButton
 */
public interface PluginSwitchButtonBuilder extends PluginBaseCompoundButtonBuilder<PluginSwitchButtonBuilder> {

}
