package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginButton;

/**
 * 插件按钮构建器接口
 * <p>
 * 按钮继承了文本视图的所有属性设置能力，包括文本内容、字体大小、颜色等。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * pluginViewBuilder
 *     .addButton()
 *     .text("确认")
 *     .textSize(16)
 *     .textColor(Color.WHITE)
 *     .backgroundColor(Color.BLUE)
 *     .onClick(view -> {
 *         // 处理点击事件
 *     })
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseButtonBuilder
 * @see PluginButton
 */
public interface PluginButtonBuilder extends PluginBaseButtonBuilder<PluginButtonBuilder> {

    /**
     * 设置按钮风格，可选默认风格、填充风格、轮廓风格
     *
     * @param style 按钮风格枚举值，不能为null
     * @return 当前构建器实例，支持链式调用
     * @see PluginButton.Style
     */
    PluginButtonBuilder style(PluginButton.Style style);

}
