package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginTextView;

/**
 * 插件文本视图构建器接口
 * <p>
 * 文本视图（TextView）是用于显示文本内容的基础UI组件，支持丰富的文本样式设置，
 * 包括字体大小、颜色、对齐方式、行数控制等。是最常用的文本显示组件。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * pluginViewBuilder
 *     .addTextView("title")
 *     .text("标题")
 *     .textSize(18)
 *     .textColor(Color.BLACK)
 *     .textGravity(Gravity.CENTER)
 *     .maxLines(2)
 *     .ellipsize(TextUtils.TruncateAt.END)
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseTextViewBuilder
 * @see PluginTextView
 */
public interface PluginTextViewBuilder extends PluginBaseTextViewBuilder<PluginTextViewBuilder> {

}
