package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginRadioButton;

/**
 * 插件单选按钮构建器接口
 * <p>
 * 单选按钮通常与其他单选按钮组成一个单选组，在同一组中只能有一个按钮处于选中状态。
 * 当用户选择某个单选按钮时，同组的其他单选按钮会自动取消选中。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * pluginViewBuilder
 *     .addRadioGroup(true).children(builder -> builder
 *         .addRadioButton("radio1").text("选项1")
 *         .addRadioButton("radio2").text("选项2")
 *         .addRadioButton("radio3").text("选项3")
 *     ).check("radio1")
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseCompoundButtonBuilder
 * @see PluginRadioButton
 */
public interface PluginRadioButtonBuilder extends PluginBaseCompoundButtonBuilder<PluginRadioButtonBuilder> {

}