package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginProgressBar;

/**
 * 插件进度条构建器接口
 * <p>
 * 进度条是一个用于显示操作进度或加载状态的UI组件。支持水平和圆形两种主要样式，
 * 可以显示确定进度（显示具体百分比）或不确定进度（显示动画但不显示具体进度）。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * // 创建水平确定进度条
 * pluginViewBuilder
 *     .addProgressBar("processing")
 *     .maxProgress(100)
 *     .progress(45)
 *     ...
 *
 * // 创建水平不确定进度条
 * pluginViewBuilder
 *     .addProgressBar("loading")
 *     .indeterminate(true)
 *     ...
 *
 * // 创建圆形不确定进度条
 * pluginViewBuilder
 *     .addProgressBar("loading")
 *     .style(PluginProgressBar.Style.CIRCULAR)
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseViewBuilder
 * @see PluginProgressBar
 */
public interface PluginProgressBarBuilder extends PluginBaseViewBuilder<PluginProgressBarBuilder> {

    /**
     * 设置进度条样式
     * <p>
     * 默认为水平风格（HORIZONTAL）。不同样式支持的功能特性不同：
     * <ul>
     * <li>HORIZONTAL：支持确定和不确定进度，可设置进度值</li>
     * <li>CIRCULAR系列：仅支持不确定进度，显示旋转动画</li>
     * </ul>
     * </p>
     *
     * @param style 进度条样式
     * @return 当前构建器实例，支持链式调用
     * @see PluginProgressBar.Style
     */
    PluginProgressBarBuilder style(PluginProgressBar.Style style);

    /**
     * 设置当前进度值
     * <p>
     * 仅水平风格进度条可设置该选项，圆形进度条会忽略此设置。
     * 进度值应在0到maxProgress范围内。
     * </p>
     *
     * @param progress 进度值，应在0到maxProgress范围内
     * @return 当前构建器实例，支持链式调用
     */
    PluginProgressBarBuilder progress(int progress);

    /**
     * 设置次要进度值
     * <p>
     * 仅水平风格进度条可设置该选项，圆形进度条会忽略此设置。
     * 次要进度值应在0到maxProgress范围内，通常大于或等于当前进度，一般用于缓冲场景。
     * </p>
     *
     * @param secondaryProgress 次要进度值，应在0到maxProgress范围内
     * @return 当前构建器实例，支持链式调用
     */
    PluginProgressBarBuilder secondaryProgress(int secondaryProgress);

    /**
     * 设置最大进度值
     * <p>
     * 默认最大进度为100。仅水平风格进度条可设置该选项，圆形进度条会忽略此设置。
     * 设置最大进度值后，当前进度和次要进度的有效范围为0到maxProgress。
     * </p>
     *
     * @param maxProgress 最大进度值，必须大于0
     * @return 当前构建器实例，支持链式调用
     */
    PluginProgressBarBuilder maxProgress(int maxProgress);

    /**
     * 设置是否为不确定进度模式
     * <p>
     * 仅水平风格进度条可设置该选项，圆形进度条默认为不确定进度模式。
     * 在不确定进度模式下，进度条会显示循环动画，忽略具体的进度值设置。
     * 适用于无法确定具体进度的长时间操作。
     * </p>
     *
     * @param indeterminate true设置为不确定进度模式，false设置为确定进度模式
     * @return 当前构建器实例，支持链式调用
     */
    PluginProgressBarBuilder indeterminate(boolean indeterminate);
}
