package bin.mt.plugin.api.ui.builder;

import bin.mt.plugin.api.ui.PluginLinearLayout;

/**
 * 插件线性布局构建器接口
 * <p>
 * 线性布局是一种将子View按水平或垂直方向线性排列的容器布局。
 * </p>
 * <p>
 * <strong>使用示例：</strong>
 * <pre>{@code
 * pluginViewBuilder
 *     .addHorizontalLayout().children(builder -> builder
 *         .addTextView().text("标题")
 *         .addEditText().hint("输入内容")
 *     )
 *     ...
 * }</pre>
 * </p>
 *
 * @see PluginBaseLinearLayoutBuilder
 * @see PluginLinearLayout
 */
public interface PluginLinearLayoutBuilder extends PluginBaseLinearLayoutBuilder<PluginLinearLayoutBuilder> {

}