package bin.mt.plugin.api.ui.builder;

/**
 * 插件线性布局构建器基础接口
 * <p>
 * 线性布局是一种将子View按水平或垂直方向线性排列的容器布局。
 * </p>
 *
 * @param <T> 具体的构建器类型，使用泛型实现链式调用的类型安全
 * @see PluginBaseViewGroupBuilder
 * @see PluginLinearLayoutBuilder
 */
public interface PluginBaseLinearLayoutBuilder<T extends PluginViewBuilder> extends PluginBaseViewGroupBuilder<T> {

    /**
     * 判断当前布局是否为水平方向
     * <p>
     * 水平布局表示子View从左到右依次排列。
     * </p>
     *
     * @return true表示水平布局，false表示垂直布局
     */
    boolean isHorizontal();

    /**
     * 判断当前布局是否为垂直方向
     * <p>
     * 垂直布局表示子View从上到下依次排列。
     * </p>
     *
     * @return true表示垂直布局，false表示水平布局
     */
    boolean isVertical();

    /**
     * 设置布局的对齐方式
     * <p>
     * 对于垂直布局，可以设置子View的水平对齐（如Gravity.CENTER_HORIZONTAL、Gravity.LEFT等）
     * 对于水平布局，可以设置子View的垂直对齐（如Gravity.CENTER_VERTICAL、Gravity.TOP等）
     * </p>
     * <p>
     * 常用的对齐方式属性值：
     * <ul>
     * <li>Gravity.CENTER - 居中对齐</li>
     * <li>Gravity.LEFT - 左对齐（水平方向）</li>
     * <li>Gravity.RIGHT - 右对齐（水平方向）</li>
     * <li>Gravity.TOP - 顶部对齐（垂直方向）</li>
     * <li>Gravity.BOTTOM - 底部对齐（垂直方向）</li>
     * <li>Gravity.CENTER_HORIZONTAL - 水平居中</li>
     * <li>Gravity.CENTER_VERTICAL - 垂直居中</li>
     * </ul>
     * </p>
     *
     * @param gravity 对齐方式，使用Gravity常量
     * @return 当前构建器实例，支持链式调用
     * @see android.view.Gravity
     */
    T gravity(int gravity);
}