package bin.mt.plugin.api.ui;

import androidx.annotation.Nullable;

/**
 * 插件单选按钮组接口
 *
 * @see bin.mt.plugin.api.ui.builder.PluginRadioGroupBuilder
 */
public interface PluginRadioGroup extends PluginLinearLayout {

    /**
     * 选中指定ID的单选按钮
     * <p>
     * 当调用此方法时，会自动取消当前选中的按钮，并选中指定ID的按钮。
     * 如果指定的ID不存在于当前单选按钮组中，则全部按钮将取消选中。
     * </p>
     *
     * @param id 要选中的单选按钮的ID
     */
    void check(@Nullable String id);

    /**
     * 选中指定位置的单选按钮
     * <p>
     * 当调用此方法时，会自动取消当前选中的按钮，并选中指定位置的按钮。
     * 指定位置从0开始，如果超出范围（比如-1）则全部按钮将取消选中。
     * </p>
     *
     * @param id 要选中的单选按钮的位置
     * @see PluginRadioButton#getPositionInRadioGroup()
     */
    void check(int index);

    /**
     * @return 当前选中的单选按钮ID，如果没有选中的按钮则返回null
     */
    @Nullable
    String getCheckedRadioButtonId();

    /**
     * @return 当前选中的单选按钮的位置，如果没有选中的按钮则返回-1
     * @see PluginRadioButton#getPositionInRadioGroup()
     */
    int getCheckedRadioButtonPosition();

    /**
     * @return 当前选中的单选按钮，如果没有选中的按钮则返回null
     */
    @Nullable
    PluginRadioButton getCheckedRadioButton();

    /**
     * 清除所有单选按钮的选中状态
     */
    void clearCheck();

    /**
     * 设置选中状态改变监听器
     *
     * @param listener 选中状态改变监听器，传入null则移除当前监听器
     */
    void setOnCheckedChangeListener(OnCheckedChangeListener listener);

    /**
     * 单选按钮组选中状态改变监听器接口
     * <p>
     * 用于监听单选按钮组中选中状态的改变事件。
     * 当用户选中或取消选中某个单选按钮时，会触发此接口的回调方法。
     * </p>
     */
    interface OnCheckedChangeListener {

        /**
         * 当单选按钮组的选中状态发生改变时调用
         *
         * @param group           发生选中状态改变的单选按钮组实例
         * @param checkedButton   当前选中的单选按钮，如果没有选中的按钮则为null
         * @param checkedPosition 当前选中的单选按钮的位置，从0开始，如果没有选中的按钮则为-1
         * @see PluginRadioButton#getPositionInRadioGroup()
         */
        void onCheckedChanged(PluginRadioGroup group, @Nullable PluginRadioButton checkedButton, int checkedPosition);
    }

}
