package bin.mt.plugin.api.ui;

/**
 * 插件线性布局接口
 * 继承自PluginViewGroup，提供线性排列的布局容器功能
 * 子View可以水平或垂直方向排列
 *
 * @see bin.mt.plugin.api.ui.builder.PluginLinearLayoutBuilder
 */
public interface PluginLinearLayout extends PluginViewGroup {

    /**
     * @return 是否为水平布局
     */
    boolean isHorizontal();

    /**
     * @return 是否为垂直布局
     */
    boolean isVertical();

    /**
     * @return 子View在布局中的对齐方式
     */
    int getGravity();

    /**
     * 设置子View在布局中的对齐方式
     *
     * @param gravity 对齐方式，如Gravity.CENTER、Gravity.LEFT等
     */
    void setGravity(int gravity);
}
