package bin.mt.plugin.api.ui;

import androidx.annotation.Nullable;

/**
 * 插件复合按钮接口
 * 继承自PluginButton，为所有可选中的按钮组件提供基础功能
 * 包括复选框、单选按钮、开关按钮等
 */
public interface PluginCompoundButton extends PluginButton {

    /**
     * 设置按钮的选中状态
     *
     * @param isChecked true表示选中，false表示未选中
     */
    void setChecked(boolean isChecked);

    /**
     * 获取按钮当前的选中状态
     *
     * @return true表示已选中，false表示未选中
     */
    boolean isChecked();

    /**
     * 设置选中状态改变监听器
     *
     * @param listener 状态改变监听器，可以为null表示移除监听器
     */
    void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener);

    /**
     * @deprecated 复合按钮无此功能，此方法总是返回DEFAULT
     */
    @Deprecated
    @Override
    Style getStyle();

    /**
     * 选中状态改变监听器接口
     * 当用户点击按钮改变选中状态时会触发此回调
     */
    interface OnCheckedChangeListener {

        /**
         * 当按钮选中状态发生改变时的回调方法
         *
         * @param buttonView 状态发生改变的按钮视图
         * @param isChecked  新的选中状态，true表示选中，false表示未选中
         */
        void onCheckedChanged(PluginCompoundButton buttonView, boolean isChecked);
    }
}
